<%--
$Header: Common.inc, 66, 5/31/01 4:52:59 PM, Schwartz, Joe$
$Log: 
 66   Alkindi Development1.65        5/31/01 4:52:59 PM   Schwartz, Joe  
      Modified content for demo.
 65   Alkindi Development1.64        5/9/01 9:47:37 AM    Schwartz, Joe   Added
      constant for Alkindi Software page.
 64   Alkindi Development1.63        3/8/01 12:32:18 PM   Schwartz, Joe   Fixed
      up to work again with sessionless RecMgr.
 63   Alkindi Development1.62        3/5/01 2:29:04 PM    Schwartz, Joe  
      Changes to accomodate persistent RecMgr connection.
 62   Alkindi Development1.61        2/23/01 5:39:18 PM   Schwartz, Joe   Basic
      changes for new RecMgr interface, new Product id type (int) and
      Rating/Recommendation evaluation type (float).
 61   Alkindi Development1.60        1/24/01 2:26:16 PM   Schwartz, Joe  
      Changed refs to ForgetMe to ForgetLogin.
 60   Alkindi Development1.59        1/23/01 6:00:28 PM   Schwartz, Joe   Added
      new ForgetMe.jsp page.
 59   Alkindi Development1.58        1/19/01 3:45:04 PM   Schwartz, Joe   Temp.
      commented out email session variable.
 58   Alkindi Development1.57        1/19/01 3:18:35 PM   Schwartz, Joe   Added
      getCookie() function to return cookie by name.
 57   Alkindi Development1.56        1/19/01 12:40:51 PM  Schwartz, Joe   Got
      rid of refreshTag() function (replaced with new Refresh.inc page). Put
      page timeout config param names at page scope.
 56   Alkindi Development1.55        1/18/01 4:04:59 PM   Schwartz, Joe  
      Changed String compareTo() to equals() where possible; renamed _SESSID
      constants to _SESSVAR.
 55   Alkindi Development1.54        1/17/01 7:51:59 PM   Schwartz, Joe  
      Changed refreshTag() to use parameters from ServletContext (web.xml).
 54   Alkindi Development1.53        1/16/01 12:49:26 PM  Schwartz, Joe   Made
      kiosk timeout 2 min.
 53   Alkindi Development1.52        1/16/01 12:18:26 PM  Schwartz, Joe   Made
      getAlkindexImage return entire html image tag.
 52   Alkindi Development1.51        1/16/01 10:39:10 AM  Schwartz, Joe  
      Corrected logout timeout.
 51   Alkindi Development1.50        1/15/01 5:07:44 PM   Schwartz, Joe   Fixed
      missing semicolon in refreshTag() (NS wouldn't use URL otherwise).
 50   Alkindi Development1.49        1/15/01 4:02:58 PM   Schwartz, Joe   Added
      refreshTag() function to generate appropriate meta refresh tag.
 49   Alkindi Development1.48        1/11/01 8:12:45 PM   Stanton, Sacha  added
      AVGRATING_PARAM = "avgrat"
 48   Alkindi Development1.47        1/10/01 3:33:58 PM   Schwartz, Joe   Added
      MyDetails page and parameter value constants.
 47   Alkindi Development1.46        1/10/01 10:32:43 AM  Schwartz, Joe  
      Removed some extra CRs.
 46   Alkindi Development1.45        1/10/01 10:21:09 AM  Schwartz, Joe   Added
      isUserLoggedIn() function.
 45   Alkindi Development1.44        1/9/01 11:38:09 AM   Schwartz, Joe  
      Removed some superfluous CRs.
 44   Alkindi Development1.43        1/8/01 5:43:09 PM    Schwartz, Joe   Added
      requestContains function that checks if the URI in the current request
      contains the given string.
 43   Alkindi Development1.42        1/5/01 3:02:20 PM    Schwartz, Joe  
      Chagned paramProcessXmlWithXsl to use StringTransformer instead of
      StreamTransformer.
 42   Alkindi Development1.41        1/5/01 1:00:32 PM    Schwartz, Joe   Added
      requestContains() function. Added source control keywords.
 41   Alkindi Development1.40        12/29/00 5:58:20 PM  Schwartz, Joe  
      Chagned to reflect new MW package names.
 40   Alkindi Development1.39        12/21/00 4:56:18 PM  Stanton, Sacha  
 39   Alkindi Development1.38        12/11/00 5:18:13 PM  Schwartz, Joe   
 38   Alkindi Development1.37        12/11/00 4:38:37 PM  Schwartz, Joe  
      Removed showErrorPage(). Changed processXmlWithXsl to call
      paramProcessXmlWithXsl.
 37   Alkindi Development1.36        12/5/00 11:20:23 AM  Schwartz, Joe   
 36   Alkindi Development1.35        12/4/00 12:46:48 PM  Stanton, Sacha  
 35   Alkindi Development1.34        12/1/00 2:44:28 PM   Schwartz, Joe   
 34   Alkindi Development1.33        12/1/00 1:17:25 PM   Stanton, Sacha  
 33   Alkindi Development1.32        11/30/00 6:22:54 AM  Stanton, Sacha  
 32   Alkindi Development1.31        11/29/00 3:01:06 PM  Schwartz, Joe   
 31   Alkindi Development1.30        11/27/00 5:08:09 PM  Stanton, Sacha  
 30   Alkindi Development1.29        11/26/00 7:49:50 PM  Stanton, Sacha  
 29   Alkindi Development1.28        11/25/00 8:01:31 PM  Stanton, Sacha  
 28   Alkindi Development1.27        11/25/00 12:28:51 AM Stanton, Sacha  

 27   Alkindi Development1.26        11/22/00 6:34:53 PM  Schwartz, Joe   
 26   Alkindi Development1.25        11/22/00 1:03:05 PM  Schwartz, Joe   
 25   Alkindi Development1.24        11/21/00 11:17:29 PM Schwartz, Joe   
 24   Alkindi Development1.23        11/20/00 10:51:09 PM Schwartz, Joe   
 23   Alkindi Development1.22        11/20/00 12:06:26 PM Schwartz, Joe   
 22   Alkindi Development1.21        11/19/00 9:16:50 PM  Stanton, Sacha  
 21   Alkindi Development1.20        11/19/00 9:14:14 PM  Schwartz, Joe   
 20   Alkindi Development1.19        11/19/00 8:47:03 PM  Schwartz, Joe   
 19   Alkindi Development1.18        11/19/00 6:04:21 PM  Schwartz, Joe   
 18   Alkindi Development1.17        11/18/00 7:39:58 PM  Schwartz, Joe   
 17   Alkindi Development1.16        11/18/00 10:52:22 AM Schwartz, Joe   
 16   Alkindi Development1.15        11/14/00 5:49:35 PM  Schwartz, Joe   
 15   Alkindi Development1.14        11/14/00 12:51:08 PM Schwartz, Joe   
 14   Alkindi Development1.13        11/11/00 5:00:52 PM  Schwartz, Joe   
 13   Alkindi Development1.12        11/11/00 11:25:19 AM Schwartz, Joe   
 12   Alkindi Development1.11        11/11/00 11:17:27 AM Schwartz, Joe   
 11   Alkindi Development1.10        11/11/00 11:17:06 AM Schwartz, Joe   
 10   Alkindi Development1.9         11/9/00 9:55:15 PM   Schwartz, Joe   
 9    Alkindi Development1.8         11/8/00 7:46:32 PM   Schwartz, Joe   
 8    Alkindi Development1.7         11/8/00 5:50:06 PM   Schwartz, Joe   
 7    Alkindi Development1.6         11/6/00 7:06:10 PM   Schwartz, Joe   
 6    Alkindi Development1.5         11/1/00 11:08:25 PM  Schwartz, Joe   
 5    Alkindi Development1.4         10/30/00 7:49:18 PM  Schwartz, Joe   
 4    Alkindi Development1.3         10/25/00 6:39:13 PM  Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:38 PM  Schwartz, Joe   
 2    Alkindi Development1.1         10/18/00 3:03:21 PM  Schwartz, Joe   
 1    Alkindi Development1.0         10/13/00 5:12:41 PM  Schwartz, Joe   
$
$NoKeywords$
--%><%@page import="java.util.*,java.io.IOException,java.rmi.*,javax.naming.*,javax.rmi.PortableRemoteObject"%><%@page import="Alkindi.Services.*,Alkindi.Data.*,Alkindi.Services.BeanIface.*,Alkindi.Services.StubBeanImpl.*,java.security.MessageDigest,gnu.regexp.*,org.xml.sax.*,com.caucho.xsl.*,com.caucho.transform.*,com.caucho.vfs.*,com.caucho.util.*"%><%@include file="ClientUtils.inc"%><%! 


//////////////////////////////////////////////////////////////
//
//	**** Constants ****
//

//	Host Names
//
final String WWW_HOST = "www.alkindi.com";
final String KIOSK_HOST = "kiosk.alkindi.com";
final String WAP_HOST = "wap.alkindi.com";

//	Relative URIs of main pages, used in links.
//
final String START_PAGE	="index.jsp";
final String LOGOUT_PAGE="Logout.jsp";
final String RESET_SESSION_PAGE = "ResetSession.jsp";
final String MY_ALKINDI_PAGE = "MyAlkindi.jsp";
final String IMPROVE_ALKINDEX_PAGE = "ImproveAlkindex.jsp";
final String MY_DETAILS_PAGE = "MyDetails.jsp";
final String ALKINDI_RECS_PAGE = "AlkindiRecs.jsp";
final String REAL_VIEWS_PAGE = "RealViews.jsp";
final String MY_LIST_PAGE = "MyList.jsp";
final String ERROR_PAGE = "Error.jsp";
final String GENERIC_ERROR_PAGE = "GenericError.jsp";
final String SIGNUP_RATE_MOVIES_PAGE = "SignUp_RateMoreMovies.jsp";
final String SIGNUP_CREATEACCT_PAGE = "SignUp_CreateAccount.jsp";
final String PRODUCT_PAGE = "Product.jsp";
final String FORGOT_PWD_PAGE = "ForgotPassword.jsp";
final String FORGOT_PWD_PAGE_2 = "ForgotPassword_questions.jsp";
final String FORGOT_PWD_PAGE_3 = "ForgotPassword_done.jsp";
final String PRIVACY_PAGE="Privacy.jsp";
final String TERMS_PAGE="Terms.jsp";
final String FAQ_PAGE="FAQ.jsp";
final String ABOUT_PAGE="About.jsp";
final String SEARCH_RESULTS_PAGE="SearchResults.jsp";
final String TELLFRIEND_PAGE = "TellFriend.jsp";
final String EMAIL_ALKINDI_PAGE = "EmailAlkindi.jsp";
final String WAP_PAGE = "WAP.jsp";
final String FORGET_LOGIN_PAGE = "ForgetLogin.jsp";
final String ALKINDI_SW_PAGE = "AlkindiSoftware.jsp";

//	Email Addresses
//
final String EMAIL_HELP_ADDRESS = "help@alkindi.com";
final String EMAIL_REALVIEWS_ADDRESS = "realviews@alkindi.com";
final String EMAIL_KIOSKINFO_ADDRESS = "stationinfo@alkindi.com";
final String EMAIL_FEEDBACK_ADDRESS = "feedback@alkindi.com";
final String EMAIL_INFO_ADDRESS = "info@alkindi.com";
final String EMAIL_RECRUIT_ADDRESS = "recruit@alkindi.com";
final String EMAIL_WEBMASTER_ADDRESS = "webmaster@alkindi.com";
final String EMAIL_COMMUNITY_ADDRESS = "community@alkindi.com";

//	Cookie names:
//
final String LOGIN_COOKIE	= 	"loginck";
final String PWD_COOKIE		=	"pwdck";
//	Form parameters
//
//		validation params
//
final String LOGIN_PARAM = "login";
final String EMAIL_PARAM = "email";
final String PWD_PARAM = "pwd";
final String PWD2_PARAM = "pwd2";
final String VALIDQ1_PARAM = "validationQ1";
final String VALIDQ2_PARAM = "validationQ2";
final String VALIDA1_PARAM = "validationA1";
final String VALIDA2_PARAM = "validationA2";
final String REMEMBER_LOGIN_PARAM = "rememli";

//		basic demographics params
//
final String SEX_PARAM = "sex";
final String EDU_PARAM = "edu";
final String SCREENNAME_PARAM = "screenName";
final String WANTEMAIL_PARAM = "wantEmail";
final String POSTALCODE_PARAM = "postalCode";
final String BDAY_DATE_PARAM = "bdayDate";
final String BDAY_MON_PARAM = "bdayMon";
final String BDAY_YEAR_PARAM = "bdayYear";
//		User Details list params
//
final String ACTIVITY_PARAM = "actpref";
final String GENRE_PARAM = "genrepref";
final String INTEREST_PARAM = "interestpref";
final String LANGUAGE_PARAM = "langpref";
final String PROFESSION_PARAM = "profession";
final String SPORT_PARAM = "sportpref";
//		Search params
//
final String QUICK_SEARCH_TEXT_PARAM="qsearcht";
final String QUICK_SEARCH_CATEGORY_PARAM="qsearchc";
//		other params
//
final String USERID_PARAM = "userID";
final String PASSWORD_PARAM = "pwd";
final String RATING_PARAM = "rat";
final String AVGRATING_PARAM = "avgrat";
final String PRODID_PARAM = "ratPID";
final String REC_PROD_CAT_PARAM = "recProdCat";
final String PREDRATING_PARAM = "pR";
final String QUESTION_PARAM = "dummyQuestion";
final String ANSWER_PARAM = "dummyAnswer";
final String DEL_MYLIST_PARAM = "delML";
final String ADD_MYLIST_PARAM = "addML";
final String ABOUT_PARAM = "about";
final String REAL_VIEWS_PARAM = "rvpage";
final String EMAIL_TO_PARAM = "emtowho";
final String EMAIL_TEXT_PARAM = "emtext";
final String EMAIL_FROM_PARAM = "emfrom";

//	Hidden parameter names
//
final String CREATE_ACCT_HIDDEN_FIELD = "CAHF";
final String GET_MORE_RECS_FLAG = "GMRBYHF";
final String DETAILS_PAGE_PARAM="detailsPage";
final String DETAILS_HIDDEN_FIELD = "DHF";
final String FORGOT_HIDDEN_FIELD = "fgt";
final String SEARCH_RESULTS_HIDDEN_FIELD="srhf";

//	Form names
//
final String RATS_FORM_NAME = "ratsForm";
final String CREATE_ACCT_FORM_NAME = "caForm";
final String DETAILS_FORM_NAME="detailsForm";

//	Special form param values
//
final String SUBMIT_RATEMORE = "sarm";
//	Session Variable names
//
final String LOGGEDIN_SESSVAR = "userLoggedIn";
final String ACCTINFO_SESSVAR = "AI";
final String USER_SESSVAR = "user";
final String RL1_SESSVAR = "RL1";
final String RL2_SESSVAR = "RL2";
final String RL3_SESSVAR = "RL3";
final String IMPALK_RL_SESSVAR = "IARL";
final String MYALK_RECLIST_SESSVAR = "MYALK_RECLIST";
final String MYALK_RATLIST_SESSVAR = "MYALK_RATINGS";
final String ALKRECS_RECLIST_SESSVAR = "ALKRECS_RECLIST";
final String ALKRECS_RATLIST_SESSVAR = "ALKRECS_RATLIST";
final String SEARCH_RESULTS_SESSVAR = "SEARCH_RESULTS";
//final String USER_EMAIL_SESSVAR="email";

//	Request attribute names
//
final String FORGOT_PWD_QUESTIONS = "fpqs";
final String ERRMSG_PARAM="errmsg";
final String PROBLEM_URI_PARAM="problemURI";

//	Configuration properties
//
final String EMAIL_REPLYTO_PROP = "email.reply-to";
final String SMTP_SERVER_PROP = "smtp.server";
final String EMAIL_CHANGEPASS_SUBJ_PROP = "email.changepass.subject";
final String LOGOUT_TIMEOUT_PARAM = "logout.timeout";
final String WWW_TIMEOUT_PARAM = "www.timeout";
final String KIOSK_TIMEOUT_PARAM = "kiosk.timeout";

//	Contants used for About hyperlinks and request parameters.
//
final String ABOUT_US = "us";
final String ABOUT_TEAM = "team";
final String ABOUT_INVESTORS = "investors";
final String ABOUT_JOBS = "jobs";
final String ABOUT_PARTNERS = "partners";
final String ABOUT_PRESS = "press";
final String ABOUT_CONTACT = "contact";

//	About page names
//
final String ABOUT_US_PAGE = "About_us.jsp";
final String ABOUT_TEAM_PAGE = "About_team.jsp";
final String ABOUT_INVESTORS_PAGE = "About_investors.jsp";
final String ABOUT_JOBS_PAGE = "About_jobs.jsp";
final String ABOUT_PARTNERS_PAGE = "About_partners.jsp";
final String ABOUT_PRESS_PAGE = "About_press.jsp";
final String ABOUT_CONTACT_PAGE = "About_contact.jsp";

//	MyDetails page names
//
final String MY_DETAILS_DEMOG_PAGE = "MyDetails_demographics.jsp";
final String MY_DETAILS_OCC_PAGE = "MyDetails_occupation.jsp";
final String MY_DETAILS_MOVIEPREF_PAGE =  "MyDetails_movieprefs.jsp";
final String MY_DETAILS_INTEREST_PAGE = "MyDetails_interests.jsp";
final String MY_DETAILS_OTHER_PAGE = "MyDetails_other.jsp";

//	Constants used for Details page parameters.
//
final String MY_DETAILS_DEMOG = "demographics";
final String MY_DETAILS_OCC = "occupation";
final String MY_DETAILS_MOVIEPREF = "movieprefs";
final String MY_DETAILS_INTEREST = "hobbies";
final String MY_DETAILS_EMAIL = "email";
final String MY_DETAILS_PRIVACY = "privacy";
final String MY_DETAILS_SCREENNAME = "screenname";
final String MY_DETAILS_PWD = "pwd";
final String MY_DETAILS_FORGOTPWD = "forgotpwd";

//	RealViews Contants used for hyperlinks and request parameters.
//
final String REALVIEW_INDEX = "index";
final String REALVIEW_RV1 = "rv1";
final String REALVIEW_RV2 = "rv2";
final String REALVIEW_RV3 = "rv3";
final String REALVIEW_RV4 = "rv4";
final String REALVIEW_RV5 = "rv5";
final String REALVIEW_RV6 = "rv6";
final String REALVIEW_RV7 = "rv7";
final String REALVIEW_RV8 = "rv8";

//	RealViews Contants used for page names
//
final String REALVIEW_INDEX_PAGE = "rv_index.jsp";
final String REALVIEW_RV1_PAGE = "rv1.jsp";
final String REALVIEW_RV2_PAGE = "rv2.jsp";
final String REALVIEW_RV3_PAGE = "rv3.jsp";
final String REALVIEW_RV4_PAGE = "rv4.jsp";
final String REALVIEW_RV5_PAGE = "rv5.jsp";
final String REALVIEW_RV6_PAGE = "rv6.jsp";
final String REALVIEW_RV7_PAGE = "rv7.jsp";
final String REALVIEW_RV8_PAGE = "rv8.jsp";


//      Number of banner ads available
final String BANNER_ADS[][]=	{{"ordinary_reviews.gif", REAL_VIEWS_PAGE},};

//	Release number
//
final String RELNUM_INIT_PARAM = "ReleaseNumber";

//	DocType
//
final String DOC_TYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";

//////////////////////////////////////////////////////////////
//
//	getPostedUser()
//
//		Retrieves the SystemUser associated with the
//		user ID in the request.
//
public SystemUser getPostedUser(HttpServletRequest req)
{
	String uids = req.getParameter(USERID_PARAM);
	SystemUser su = null;
	if (uids != null) {
		try {
			int uidi = Integer.parseInt(uids);
			su = new SystemUser(uidi);
		}
		catch(NumberFormatException nfe) {
//			out.println("Bad user ID format.<br/>");
		}
	}
	return su;
}




//////////////////////////////////////////////////////////////
//
//	getPostedRatings()
//
public RatingList getPostedRatings(SystemUser su, HttpServletRequest req)
	throws AlkExcept
{
	try {
		RatingList rl = null;
		String prodIDs[] = req.getParameterValues(PRODID_PARAM);
		String ratings[] = req.getParameterValues(RATING_PARAM);
		if ((prodIDs == null) || (ratings == null)) {
			return null;
		}	
		
		//	Prepare a list of ratings
		//
		rl = new RatingList();
		for (int idx = 0; idx < prodIDs.length; idx ++) {
			int prodID = Integer.parseInt(prodIDs[idx]);
			float rating = Float.parseFloat(ratings[idx]);
			Product prod = new Product(prodID);
			Rating rat = new Rating(su, prod, rating);
			rl.add(rat);
		}
		
//		Rating rat = new Rating(su, new Product(300), 5);
//		rl.add(rat);
		return rl;
	}
	catch(Exception e) {
		throw new AlkExcept(e.toString(), 7008);
	}


}

//////////////////////////////////////////////////////////////
//
//	handlePostedRatings()
//
//		Parses out the ratings posted in the given request.
//		Submits them to the database and stores them at 
//		session scope using the given session ID.
//
//		Returns true if ratings were submitted, false
//		otherwise.
//
public boolean handlePostedRatings(HttpServletRequest req, String ratingsSessID)
	throws AlkExcept, RemoteException, javax.ejb.CreateException
{
	HttpSession sess = req.getSession(false);
	SystemUser user = (SystemUser)sess.getAttribute(USER_SESSVAR);
	if (null == user) {
		throw new AlkExcept("No session user.", 7010);
	}
	if (user.id < 1) {
		throw new AlkExcept("Bad user at session layer.", 7011);
	}
	RatingList rl = getPostedRatings(user, req);
	if (rl == null) return false;
		
	//	Store at session if a session variable name is provided.
	//
	if (ratingsSessID != null) {
		sess.setAttribute(ratingsSessID, rl);
	}
	try {
		getRatingMgr().rateProducts(rl);
		getClusterMgr().clusterUser(user);
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Error ratings products: " + e.toString(), 7012);
	}
	
	// Handle any additions to the user's MyList as well.
	//
	handleMyListAdditions(req, user);
	
	return true;
	
}

//////////////////////////////////////////////////////////////
//
//	handleMyListAdditons()
//
void handleMyListAdditions(HttpServletRequest req, SystemUser user)
	throws AlkExcept
{
	//	Add selected items to MyList
	//
	try {
		String addMyList[] = req.getParameterValues(ADD_MYLIST_PARAM);
		IAccountManager acctMgr = getAcctMgr();
		if (null != addMyList) {
			for (int idx=addMyList.length; --idx > -1; ) {
				int prodID = Integer.parseInt(addMyList[idx]);
				acctMgr.addToMyList(user, new Product(prodID));
			}
		}
	}
	catch(AlkExcept ae){
		throw ae;
	}
	catch(Exception e) {
		throw new AlkExcept("Error adding products to MyList", 7013);
	}
}

//////////////////////////////////////////////////////////////
//
//	getPostedAccountInfo()
//	
//		Parses most of the account info posted to CreateAccount.jsp
//		into a new instance of AccountInfo.
public AccountInfo getPostedAccountInfo(HttpServletRequest req)
{
	AccountInfo ai = new AccountInfo();
	ai.email = (String)req.getParameter(EMAIL_PARAM);
	ai.screenName = (String)req.getParameter(SCREENNAME_PARAM);
	return ai;

}

//////////////////////////////////////////////////////////////
//
//	processXmlWithXsl()	
//
//		Processes the given XML file with the given XSL 
//		stylesheet. Returns the result as a String.
//
public String processXmlWithXsl(String xmlFile, String xslSheet) throws AlkExcept
{
	return paramProcessXmlWithXsl(xmlFile, xslSheet, null);
}

//////////////////////////////////////////////////////////////
//
//	paramProcessXmlWithXsl()	
//
//		Processes the given XML file with the given XSL 
//		stylesheet. Uses the supplied Hashtable as parameters 
//		to pass to the processor. 
//		Returns the result as a String.
//
public String paramProcessXmlWithXsl(String xmlFile, String xslSheet, Hashtable params) throws AlkExcept
{
	try {
		//	Get current directory for files.
		//
		String curDir = this.getServletConfig().getServletContext().getRealPath("/");
		//	Set up Stylesheet object
		//
		StylesheetFactory fact = new Xsl();
		Stylesheet ss = fact.newStylesheet(curDir + '/' + xslSheet);
		//	Set up Transformer object
		//
		StringTransformer xformer = ss.newStringTransformer();

		//	Set top-level params using the given hashtable (if present).
		//
		if (params != null) {
			Enumeration keyEnum = params.keys();
			int count= 0;
			while(keyEnum.hasMoreElements()) {
				String key = (String)keyEnum.nextElement();
				xformer.setParameter(key, (String)params.get(key));
			}
		}
		
		//	Transform XML and return result.
		//
		return xformer.transform(curDir + '/' + xmlFile);
	}
	catch (SAXException saxe) {
		throw new AlkExcept(saxe.getMessage(), 7020);
	}
	catch (Exception e) {
		
		throw new AlkExcept(e.toString(), 7021);
	}
	
}
//////////////////////////////////////////////////////////////
//
//	getXmlMovieFile()	
//
//		Returns the path for the XML file associated 
//		with the given movie product id.
//
public String getXmlMovieFile(int id)
{
	java.text.DecimalFormat fileDecFormat = new java.text.DecimalFormat("0000000000");
	String xmlFile = fileDecFormat.format(id);
	String xmlPath = "xml/movie/" + xmlFile.substring(0,2) + '/' + xmlFile.substring(2,4) + '/' + xmlFile.substring(4,6) + '/' + xmlFile.substring(6,8);
	xmlPath += '/' + xmlFile + ".xml";
	return xmlPath;
}

//////////////////////////////////////////////////////////////
//
//	getMovieName()	
//
public String getMovieName(int id) throws AlkExcept
{
	return processXmlWithXsl(getXmlMovieFile(id), "xsl/movietitle.xsl");
}

//////////////////////////////////////////////////////////////
//
//
//	getMovieArt()
//
//		Returns the relative filepath of the artwork 
//		for the given movie.
//
public String getMovieArt(int id) throws AlkExcept
{
	String artFile = processXmlWithXsl(getXmlMovieFile(id), "xsl/movieartfile.xsl");
	if (artFile.length() < 6) {
		return "images/placeholder3.gif";
	}
	String artFilePath = "movie_art/" + artFile.substring(4,6) + '/' + artFile;
	return artFilePath;
}


//////////////////////////////////////////////////////////////
//
//	ratListFromRecList()
//
//		Generates a RatingList given a RecommendationList.
//		Useful for MyAlkindi, AlkindiRecommends, etc.
//
public RatingList ratListFromRecList(RecommendationList inList) 
{
	RatingList ratList = new RatingList();
	int len = inList.size();
	for (int idx = 0; idx < len; idx ++ ) {
		Recommendation rec = inList.get(idx);
		ratList.add(new Rating(rec.user, rec.prod, 0));
	}
	return ratList;
}

//////////////////////////////////////////////////////////////
//
//	recListFromMyList()
//
//		Generates a RecommendaitonList given a MyList.
//
public RecommendationList recListFromMyList(MyList inList) 
{
	RecommendationList recList = new RecommendationList();
	int len = inList.size();
	for (int idx = 0; idx < len; idx ++) {
		recList.add(inList.get(idx).rec);
	}
	return recList;
}

//////////////////////////////////////////////////////////////
//
//	isEmailValid()
//
//	Check that email meets minimum standards for email addresses.
//
boolean isEmailValid(String emailIn) throws AlkExcept
{
	final String illegalCharPattern = new String("(@.*@)|(\\.\\.)|(@\\.)|(\\.@)|(^\\.)");
	final String emailPattern = new String("^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$");
//	final String emailPattern = new String("[a-z]");
	boolean rc = false;
	try {
		//	First check for illegal patterns
		//
		RE re = new RE(illegalCharPattern);
		if (re.getMatch(emailIn) == null) 
		{
			//	If no illegal patterns, check that format is proper 
			//
			re = new RE(emailPattern);
			if (re.isMatch(emailIn)) {
				rc = true;
			}
		}
		re = null;
	}
	catch (REException ree) {
		throw new AlkExcept(ree.toString(), 7030);
	}
	return rc;
	
}

//////////////////////////////////////////////////////////////
//
//	releaseNum()
//
//		Returns an HTML comment string of the current Release 
//		Number
//
String releaseNum()
{
	String relNum = getServletConfig().getServletContext().getInitParameter(RELNUM_INIT_PARAM);
	return "<!-- RELEASE: " + relNum + " -->\n";
}

//////////////////////////////////////////////////////////////
//
//	getAlkindexImage()
//
//		Returns the image tag for the Alkindex.
//
String getAlkindexImage(SystemUser user) throws AlkExcept
{
	try {
		IRecommendationManagerBean recMgr = getRecMgr();
		float akx = recMgr.getAlkindex(user);
		recMgr.remove();
		long scaledAkx = Math.round(1 + akx * 19);
		String akImg = "images/alkindex" + scaledAkx + ".gif";
		return "<img src=\"" + akImg + "\" width=\"126\" height=\"73\" alt=\"The Alkindex shows how well we know your tastes. Rate more movies, and our recommendations get better!\">";
	}
	catch (Exception e) {
		throw new AlkExcept("Error in getAlkindexImage ", 7035, e);
	}
	
}

//////////////////////////////////////////////////////////////
//
//	makeAboutURI()
//
String makeAboutURI(String param)
{
	String ret = ABOUT_PAGE + '?' + ABOUT_PARAM + '=' + param;
	return ret;
}

//////////////////////////////////////////////////////////////
//
//	makeRealviewsURI()
//
String makeRealviewsURI(String param)
{
	String ret = REAL_VIEWS_PAGE + '?' + REAL_VIEWS_PARAM + '=' + param;
	return ret;
}


//////////////////////////////////////////////////////////////
//
//	makeProductURI()
//
String makeProductURI(String param)
{
	String ret = PRODUCT_PAGE + '?' + PRODID_PARAM + '=' + param;
	return ret;
}

//////////////////////////////////////////////////////////////
//
//	makeEmailAlkindiURI()
//
String makeEmailAlkindiURI(String subject)
{
	return EMAIL_ALKINDI_PAGE + '?' + EMAIL_TO_PARAM + '=' + subject;
}

//////////////////////////////////////////////////////////////
//
//	hashPassword()
//
String hashPassword(String pwd) throws AlkExcept
{
	try {
		MessageDigest md = MessageDigest.getInstance("MD5");
	
		return new String(md.digest(pwd.getBytes()));
	}
	catch(Exception e) {
		throw new AlkExcept("Error in hashPassword: " + e.toString(), 7040);
	}
}

//////////////////////////////////////////////////////////////
//
//	makeNewPassword()
//
//		Makes new password according to rules of PRD 96 & 97
//
String makeNewPassword() throws AlkExcept
{
	Random rnd = new Random();
	String pwd = "";
	try {
		//	RegExp for checking for allowed letters.
		//
		RE re = new RE("[bcdfghjklmnpqrstvwxzBCDFGHJKLMNPQRSTVWXZ0123456789]");
		for (int charsToAdd = 8; charsToAdd > 0; charsToAdd -- ) {
			char ch = '\u0000';
			while (true) {
				//	Get a random character
				//
				ch = (char)rnd.nextInt(Character.MAX_VALUE);

				//	Make sure it's a number or a consonant.
				//	
				if (re.getMatch(String.valueOf(ch)) != null) 
					break;
				
			}
			pwd += ch;					
		}
		return pwd;
	}
	catch(Exception e) {
		throw new AlkExcept("Error in makeNewPassword: " + e.toString(), 7050);		
	}
}

//////////////////////////////////////////////////////////////
//
//	readFileIntoString()
//
String readFileIntoString(String fileName) throws AlkExcept
{
	String fileContents = "";
	try {
		java.io.FileReader infile = new java.io.FileReader(fileName);
	
		while (true) {
			char []buf = new char[0x1000];
			int numRead = infile.read(buf, 0, 0x1000);
			if (numRead == -1)
				break;
			fileContents += new String(buf, 0, numRead);
		}
		return fileContents;
	}
	catch(Exception e) {
		throw new AlkExcept("Exception in readFileIntoString: " + e.toString(), 7055);
	}
}


//////////////////////////////////////////////////////////////
//
//	logoutUser()
//
public void logoutUser(HttpSession sess) 
{
	while (true) {
		Enumeration sessEnum = sess.getAttributeNames();
		if (!sessEnum.hasMoreElements()) 
			break;
		String sessName = (String)sessEnum.nextElement();
		sess.removeAttribute(sessName);
	}	
}

/////////////////////////////////////////////////////////////////////////
//
//	requestContains()
//
//	Returns true if the requested URI contains the given page name.
//	NOTE: performs case-insensitive search
//
public boolean requestContains(HttpServletRequest req, String pageName) throws AlkExcept
{
	try {
		RE re = new RE(pageName, RE.REG_ICASE);
		return (re.getMatch(req.getRequestURI()) != null);
	}
	catch (REException re) {
		throw new AlkExcept("Error testing URL " + req.getRequestURI() + " for " + pageName + ": " + re.getMessage(), 7090);
	}
}

///////////////////////////////////////////////////////////////////////////////////
//
//	isUserLoggedIn()
//
//		Returns true if the user is logged in. Currently checks for a Session value
//		of the user's email address.
//
boolean isUserLoggedIn(HttpSession sess)
{
	return (sess.getAttribute(LOGGEDIN_SESSVAR) != null);
}

///////////////////////////////////////////////////////////////////////////////////
//
//	isKiosk()
//
//		Returns true if the client is requesting from the Kiosk host.
//
boolean isKiosk(HttpServletRequest req)  throws AlkExcept
{
	try {
		RE re = new RE(KIOSK_HOST, RE.REG_ICASE);
		return (re.getMatch(req.getHeader("Host")) != null);
	}
	catch (REException re) {
		throw new AlkExcept("Error testing " + req.getRequestURI() + " for " + KIOSK_HOST + ": " + re.getMessage(), 7095);
	}
	
}

///////////////////////////////////////////////////////////////////////////////////
//
//	getCookie()
//
//		Returns the named cookie if it was submitted in the given request.
//
Cookie getCookie(HttpServletRequest req, String cookieName) 
{
	Cookie[] cookies = req.getCookies();
	if (cookies == null) 
		return null;
		
	for (int idx=cookies.length; --idx > -1; ) {
		if (cookies[idx].getName().equals(cookieName)) {
			return cookies[idx];
		}
	}
	return null;
}

%>
